/* Autogenerated file. Do not edit manually. */
/* tslint:disable */
/* eslint-disable */

import { Signer, BytesLike } from "ethers";
import { Provider, TransactionRequest } from "@ethersproject/providers";
import { Contract, ContractFactory, Overrides } from "@ethersproject/contracts";

import type { UniversalRouter } from "../UniversalRouter";

export class UniversalRouter__factory extends ContractFactory {
  constructor(signer?: Signer) {
    super(_abi, _bytecode, signer);
  }

  deploy(
    params: {
      permit2: string;
      weth9: string;
      v2Factory: string;
      v3Factory: string;
      pairInitCodeHash: BytesLike;
      poolInitCodeHash: BytesLike;
      v4PoolManager: string;
      v3NFTPositionManager: string;
      v4PositionManager: string;
    },
    overrides?: Overrides
  ): Promise<UniversalRouter> {
    return super.deploy(params, overrides || {}) as Promise<UniversalRouter>;
  }
  getDeployTransaction(
    params: {
      permit2: string;
      weth9: string;
      v2Factory: string;
      v3Factory: string;
      pairInitCodeHash: BytesLike;
      poolInitCodeHash: BytesLike;
      v4PoolManager: string;
      v3NFTPositionManager: string;
      v4PositionManager: string;
    },
    overrides?: Overrides
  ): TransactionRequest {
    return super.getDeployTransaction(params, overrides || {});
  }
  attach(address: string): UniversalRouter {
    return super.attach(address) as UniversalRouter;
  }
  connect(signer: Signer): UniversalRouter__factory {
    return super.connect(signer) as UniversalRouter__factory;
  }
  static connect(
    address: string,
    signerOrProvider: Signer | Provider
  ): UniversalRouter {
    return new Contract(address, _abi, signerOrProvider) as UniversalRouter;
  }
}

const _abi = [
  {
    inputs: [
      {
        components: [
          {
            internalType: "address",
            name: "permit2",
            type: "address",
          },
          {
            internalType: "address",
            name: "weth9",
            type: "address",
          },
          {
            internalType: "address",
            name: "v2Factory",
            type: "address",
          },
          {
            internalType: "address",
            name: "v3Factory",
            type: "address",
          },
          {
            internalType: "bytes32",
            name: "pairInitCodeHash",
            type: "bytes32",
          },
          {
            internalType: "bytes32",
            name: "poolInitCodeHash",
            type: "bytes32",
          },
          {
            internalType: "address",
            name: "v4PoolManager",
            type: "address",
          },
          {
            internalType: "address",
            name: "v3NFTPositionManager",
            type: "address",
          },
          {
            internalType: "address",
            name: "v4PositionManager",
            type: "address",
          },
        ],
        internalType: "struct RouterParameters",
        name: "params",
        type: "tuple",
      },
    ],
    stateMutability: "nonpayable",
    type: "constructor",
  },
  {
    inputs: [],
    name: "BalanceTooLow",
    type: "error",
  },
  {
    inputs: [],
    name: "ContractLocked",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "DeltaNotNegative",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "Currency",
        name: "currency",
        type: "address",
      },
    ],
    name: "DeltaNotPositive",
    type: "error",
  },
  {
    inputs: [],
    name: "ETHNotAccepted",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "commandIndex",
        type: "uint256",
      },
      {
        internalType: "bytes",
        name: "message",
        type: "bytes",
      },
    ],
    name: "ExecutionFailed",
    type: "error",
  },
  {
    inputs: [],
    name: "FromAddressIsNotOwner",
    type: "error",
  },
  {
    inputs: [],
    name: "InputLengthMismatch",
    type: "error",
  },
  {
    inputs: [],
    name: "InsufficientETH",
    type: "error",
  },
  {
    inputs: [],
    name: "InsufficientToken",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "bytes4",
        name: "action",
        type: "bytes4",
      },
    ],
    name: "InvalidAction",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidBips",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "commandType",
        type: "uint256",
      },
    ],
    name: "InvalidCommandType",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidEthSender",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidPath",
    type: "error",
  },
  {
    inputs: [],
    name: "InvalidReserves",
    type: "error",
  },
  {
    inputs: [],
    name: "LengthMismatch",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "tokenId",
        type: "uint256",
      },
    ],
    name: "NotAuthorizedForToken",
    type: "error",
  },
  {
    inputs: [],
    name: "NotPoolManager",
    type: "error",
  },
  {
    inputs: [],
    name: "OnlyMintAllowed",
    type: "error",
  },
  {
    inputs: [],
    name: "SliceOutOfBounds",
    type: "error",
  },
  {
    inputs: [],
    name: "TransactionDeadlinePassed",
    type: "error",
  },
  {
    inputs: [],
    name: "UnsafeCast",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "action",
        type: "uint256",
      },
    ],
    name: "UnsupportedAction",
    type: "error",
  },
  {
    inputs: [],
    name: "V2InvalidPath",
    type: "error",
  },
  {
    inputs: [],
    name: "V2TooLittleReceived",
    type: "error",
  },
  {
    inputs: [],
    name: "V2TooMuchRequested",
    type: "error",
  },
  {
    inputs: [],
    name: "V3InvalidAmountOut",
    type: "error",
  },
  {
    inputs: [],
    name: "V3InvalidCaller",
    type: "error",
  },
  {
    inputs: [],
    name: "V3InvalidSwap",
    type: "error",
  },
  {
    inputs: [],
    name: "V3TooLittleReceived",
    type: "error",
  },
  {
    inputs: [],
    name: "V3TooMuchRequested",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "minAmountOutReceived",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amountReceived",
        type: "uint256",
      },
    ],
    name: "V4TooLittleReceived",
    type: "error",
  },
  {
    inputs: [
      {
        internalType: "uint256",
        name: "maxAmountInRequested",
        type: "uint256",
      },
      {
        internalType: "uint256",
        name: "amountRequested",
        type: "uint256",
      },
    ],
    name: "V4TooMuchRequested",
    type: "error",
  },
  {
    inputs: [],
    name: "V3_POSITION_MANAGER",
    outputs: [
      {
        internalType: "contract INonfungiblePositionManager",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "V4_POSITION_MANAGER",
    outputs: [
      {
        internalType: "contract IPositionManager",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "commands",
        type: "bytes",
      },
      {
        internalType: "bytes[]",
        name: "inputs",
        type: "bytes[]",
      },
    ],
    name: "execute",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "commands",
        type: "bytes",
      },
      {
        internalType: "bytes[]",
        name: "inputs",
        type: "bytes[]",
      },
      {
        internalType: "uint256",
        name: "deadline",
        type: "uint256",
      },
    ],
    name: "execute",
    outputs: [],
    stateMutability: "payable",
    type: "function",
  },
  {
    inputs: [],
    name: "msgSender",
    outputs: [
      {
        internalType: "address",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [],
    name: "poolManager",
    outputs: [
      {
        internalType: "contract IPoolManager",
        name: "",
        type: "address",
      },
    ],
    stateMutability: "view",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "int256",
        name: "amount0Delta",
        type: "int256",
      },
      {
        internalType: "int256",
        name: "amount1Delta",
        type: "int256",
      },
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "uniswapV3SwapCallback",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    inputs: [
      {
        internalType: "bytes",
        name: "data",
        type: "bytes",
      },
    ],
    name: "unlockCallback",
    outputs: [
      {
        internalType: "bytes",
        name: "",
        type: "bytes",
      },
    ],
    stateMutability: "nonpayable",
    type: "function",
  },
  {
    stateMutability: "payable",
    type: "receive",
  },
];

const _bytecode =
  "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";
